// Auto-generated by scripts/generate-url-parameters.js
// Source: parameters.md

function createLookup(groups) {
  const entries = new Map();
  groups.forEach(target => {
    target.sections.forEach(section => {
      section.items.forEach(item => {
        item.aliases.forEach(alias => {
          const key = alias.toLowerCase();
          if (!entries.has(key)) {
            entries.set(key, {
              target: target.title,
              section: section.title,
              ...item
            });
          }
        });
      });
    });
  });
  return Object.freeze(Object.fromEntries(entries));
}

export const URL_PARAMETER_GROUPS = Object.freeze([
  {
    "title": "URL Parameters for the Streaming Overlay (dock.html)",
    "slug": "url-parameters-for-the-streaming-overlay-dock-html",
    "description": "These are for the main streaming overlay",
    "sections": [
      {
        "title": "Basic Configuration Parameters",
        "slug": "basic-configuration-parameters",
        "description": "",
        "items": [
          {
            "key": "session",
            "displayName": "session or s or id",
            "aliases": [
              "session",
              "s",
              "id"
            ],
            "values": "string",
            "description": "Sets the session ID for connecting to the chat"
          },
          {
            "key": "password",
            "displayName": "password",
            "aliases": [
              "password"
            ],
            "values": "string",
            "description": "Sets a password for the session"
          },
          {
            "key": "scale",
            "displayName": "scale",
            "aliases": [
              "scale"
            ],
            "values": "float",
            "description": "Adjusts the size scaling of the overlay (default: 1.0)"
          },
          {
            "key": "limit",
            "displayName": "limit",
            "aliases": [
              "limit"
            ],
            "values": "number",
            "description": "Maximum number of messages to show before older ones are removed"
          },
          {
            "key": "opacity",
            "displayName": "opacity",
            "aliases": [
              "opacity"
            ],
            "values": "0.0-1.0",
            "description": "Sets the opacity of the main overlay window"
          },
          {
            "key": "hidemenu",
            "displayName": "hidemenu or nomenu",
            "aliases": [
              "hidemenu",
              "nomenu"
            ],
            "values": "boolean or \"2\"",
            "description": "Hides the menu bar. Value of \"2\" keeps scroll lock functionality"
          },
          {
            "key": "css",
            "displayName": "css",
            "aliases": [
              "css"
            ],
            "values": "URL or CSS string",
            "description": "Applies custom CSS styling via URL or direct CSS"
          },
          {
            "key": "cssb64",
            "displayName": "cssb64 or b64css or base64css or cssbase64",
            "aliases": [
              "cssb64",
              "b64css",
              "base64css",
              "cssbase64"
            ],
            "values": "base64 string",
            "description": "Applies custom CSS styling via base64 encoded string"
          },
          {
            "key": "js",
            "displayName": "js or base64js or b64js or jsbase64 or jsb64",
            "aliases": [
              "js",
              "base64js",
              "b64js",
              "jsbase64",
              "jsb64"
            ],
            "values": "URL or base64 string",
            "description": "Loads external JavaScript (limited to trusted hosting contexts)"
          },
          {
            "key": "label",
            "displayName": "label",
            "aliases": [
              "label"
            ],
            "values": "string",
            "description": "Assigns a label to this instance"
          }
        ]
      },
      {
        "title": "Visual Style Parameters",
        "slug": "visual-style-parameters",
        "description": "",
        "items": [
          {
            "key": "darkmode",
            "displayName": "darkmode",
            "aliases": [
              "darkmode"
            ],
            "values": "boolean",
            "description": "Enables dark theme with black background"
          },
          {
            "key": "lightmode",
            "displayName": "lightmode",
            "aliases": [
              "lightmode"
            ],
            "values": "boolean",
            "description": "Enables light theme with white background"
          },
          {
            "key": "transparent",
            "displayName": "transparent or transparency",
            "aliases": [
              "transparent",
              "transparency"
            ],
            "values": "boolean",
            "description": "Makes background transparent and hides scrollbar"
          },
          {
            "key": "chroma",
            "displayName": "chroma",
            "aliases": [
              "chroma"
            ],
            "values": "hex color",
            "description": "Sets a specific background color (without #)"
          },
          {
            "key": "blur",
            "displayName": "blur or blurred",
            "aliases": [
              "blur",
              "blurred"
            ],
            "values": "number",
            "description": "Applies blur effect to messages (value in pixels)"
          },
          {
            "key": "compact",
            "displayName": "compact or overlaymode",
            "aliases": [
              "compact",
              "overlaymode"
            ],
            "values": "boolean",
            "description": "Enables compact mode with less spacing"
          },
          {
            "key": "padding",
            "displayName": "padding",
            "aliases": [
              "padding"
            ],
            "values": "number",
            "description": "Sets padding between messages in pixels"
          },
          {
            "key": "largeavatar",
            "displayName": "largeavatar",
            "aliases": [
              "largeavatar"
            ],
            "values": "boolean",
            "description": "Shows larger user avatars on the left side"
          },
          {
            "key": "emoji",
            "displayName": "emoji or emojis",
            "aliases": [
              "emoji",
              "emojis"
            ],
            "values": "number",
            "description": "Sets emoji size scaling (percentage, default: 140)"
          },
          {
            "key": "nooutline",
            "displayName": "nooutline",
            "aliases": [
              "nooutline"
            ],
            "values": "boolean",
            "description": "Removes text outline effects"
          },
          {
            "key": "font",
            "displayName": "font",
            "aliases": [
              "font"
            ],
            "values": "string",
            "description": "Sets custom font family"
          },
          {
            "key": "googlefont",
            "displayName": "googlefont",
            "aliases": [
              "googlefont"
            ],
            "values": "string",
            "description": "Loads and uses a Google Font"
          },
          {
            "key": "color",
            "displayName": "color or colorednames",
            "aliases": [
              "color",
              "colorednames"
            ],
            "values": "boolean",
            "description": "Uses platform accent colors for usernames"
          },
          {
            "key": "fontcolor",
            "displayName": "fontcolor",
            "aliases": [
              "fontcolor"
            ],
            "values": "hex color",
            "description": "Overrides the body text color"
          },
          {
            "key": "namecolor",
            "displayName": "namecolor",
            "aliases": [
              "namecolor"
            ],
            "values": "hex color",
            "description": "Overrides the username text color"
          },
          {
            "key": "fontweight",
            "displayName": "fontweight",
            "aliases": [
              "fontweight"
            ],
            "values": "number or keyword",
            "description": "Sets font weight for message text"
          },
          {
            "key": "nameweight",
            "displayName": "nameweight",
            "aliases": [
              "nameweight"
            ],
            "values": "number or keyword",
            "description": "Sets font weight for usernames"
          },
          {
            "key": "outlinewidth",
            "displayName": "outlinewidth",
            "aliases": [
              "outlinewidth"
            ],
            "values": "number",
            "description": "Width (px) of the outer outline highlight"
          },
          {
            "key": "outlinecolor",
            "displayName": "outlinecolor",
            "aliases": [
              "outlinecolor"
            ],
            "values": "hex color",
            "description": "Color applied to the outer outline highlight"
          },
          {
            "key": "strokewidth",
            "displayName": "strokewidth or stroke",
            "aliases": [
              "strokewidth",
              "stroke"
            ],
            "values": "number",
            "description": "Width (px) for the text stroke effect"
          },
          {
            "key": "strokecolor",
            "displayName": "strokecolor or strokeColor",
            "aliases": [
              "strokecolor",
              "strokeColor"
            ],
            "values": "hex color (supports 8-digit or rgba)",
            "description": "Color applied to the text stroke effect; alpha transparency supported"
          },
          {
            "key": "border",
            "displayName": "border",
            "aliases": [
              "border"
            ],
            "values": "hex color",
            "description": "Adds a profile image border using the provided color (without #)"
          },
          {
            "key": "pressedcolor",
            "displayName": "pressedcolor",
            "aliases": [
              "pressedcolor"
            ],
            "values": "hex color or empty",
            "description": "Custom highlight color for pinned/featured states"
          },
          {
            "key": "hideshadow",
            "displayName": "hideshadow",
            "aliases": [
              "hideshadow"
            ],
            "values": "boolean",
            "description": "Removes alternating card drop shadows"
          },
          {
            "key": "largecontent",
            "displayName": "largecontent",
            "aliases": [
              "largecontent"
            ],
            "values": "boolean",
            "description": "Enlarges embedded content or image cards"
          },
          {
            "key": "donationright",
            "displayName": "donationright",
            "aliases": [
              "donationright"
            ],
            "values": "number",
            "description": "Sets donation amount margin-right in pixels"
          },
          {
            "key": "bolder",
            "displayName": "bolder",
            "aliases": [
              "bolder"
            ],
            "values": "boolean",
            "description": "Applies a thicker drop shadow around text"
          },
          {
            "key": "thinner",
            "displayName": "thinner",
            "aliases": [
              "thinner"
            ],
            "values": "boolean",
            "description": "Applies a thinner drop shadow around text"
          },
          {
            "key": "unhighlight",
            "displayName": "unhighlight",
            "aliases": [
              "unhighlight"
            ],
            "values": "boolean",
            "description": "Uses an alternate style when un-featuring messages"
          },
          {
            "key": "nofeaturedhightlight",
            "displayName": "nofeaturedhightlight",
            "aliases": [
              "nofeaturedhightlight"
            ],
            "values": "boolean",
            "description": "Disables the flash highlight when a card is featured"
          },
          {
            "key": "nomemberhighlight",
            "displayName": "nomemberhighlight",
            "aliases": [
              "nomemberhighlight"
            ],
            "values": "boolean",
            "description": "Disables highlight color for member messages"
          },
          {
            "key": "noquestionhightlight",
            "displayName": "noquestionhightlight",
            "aliases": [
              "noquestionhightlight"
            ],
            "values": "boolean",
            "description": "Disables highlight color for question cards"
          }
        ]
      },
      {
        "title": "Layout Parameters",
        "slug": "layout-parameters",
        "description": "",
        "items": [
          {
            "key": "horizontal",
            "displayName": "horizontal",
            "aliases": [
              "horizontal"
            ],
            "values": "boolean",
            "description": "Makes messages scroll horizontally"
          },
          {
            "key": "horizontalreverse",
            "displayName": "horizontalreverse",
            "aliases": [
              "horizontalreverse"
            ],
            "values": "boolean",
            "description": "When horizontal is enabled, enters left-to-right mode so newest messages slide in from the left"
          },
          {
            "key": "alignbottom",
            "displayName": "alignbottom",
            "aliases": [
              "alignbottom"
            ],
            "values": "boolean",
            "description": "Makes messages start from bottom"
          },
          {
            "key": "alignright",
            "displayName": "alignright",
            "aliases": [
              "alignright"
            ],
            "values": "boolean",
            "description": "Aligns messages to the right side"
          },
          {
            "key": "rtl",
            "displayName": "rtl",
            "aliases": [
              "rtl"
            ],
            "values": "boolean",
            "description": "Enables right-to-left text direction"
          },
          {
            "key": "fixed",
            "displayName": "fixed",
            "aliases": [
              "fixed"
            ],
            "values": "boolean",
            "description": "Makes messages overlap each other"
          },
          {
            "key": "twolines",
            "displayName": "twolines",
            "aliases": [
              "twolines"
            ],
            "values": "boolean",
            "description": "Places messages on a separate line below usernames"
          },
          {
            "key": "split",
            "displayName": "split",
            "aliases": [
              "split"
            ],
            "values": "boolean",
            "description": "Enables split mode for message alignment"
          },
          {
            "key": "bubble",
            "displayName": "bubble",
            "aliases": [
              "bubble"
            ],
            "values": "boolean",
            "description": "Styles messages as chat bubbles"
          },
          {
            "key": "fadedtop",
            "displayName": "fadedtop",
            "aliases": [
              "fadedtop"
            ],
            "values": "boolean",
            "description": "Fades out the top of the overlay"
          },
          {
            "key": "reverse",
            "displayName": "reverse",
            "aliases": [
              "reverse"
            ],
            "values": "boolean",
            "description": "Displays the feed in reverse order (newest at the top)"
          },
          {
            "key": "dropdown",
            "displayName": "dropdown",
            "aliases": [
              "dropdown"
            ],
            "values": "boolean",
            "description": "Enables reverse order with drop-down style animations"
          }
        ]
      },
      {
        "title": "Animation Parameters",
        "slug": "animation-parameters",
        "description": "",
        "items": [
          {
            "key": "fadein",
            "displayName": "fadein",
            "aliases": [
              "fadein"
            ],
            "values": "boolean",
            "description": "Enables fade-in animation for new messages"
          },
          {
            "key": "fadeout",
            "displayName": "fadeout",
            "aliases": [
              "fadeout"
            ],
            "values": "boolean",
            "description": "Enables fade-out animation when removing messages"
          },
          {
            "key": "swipeleft",
            "displayName": "swipeleft",
            "aliases": [
              "swipeleft"
            ],
            "values": "boolean",
            "description": "Messages slide in from the right"
          },
          {
            "key": "swiperight",
            "displayName": "swiperight",
            "aliases": [
              "swiperight"
            ],
            "values": "boolean",
            "description": "Messages slide in from the left"
          },
          {
            "key": "swipeup",
            "displayName": "swipeup",
            "aliases": [
              "swipeup"
            ],
            "values": "boolean",
            "description": "Messages slide up from bottom"
          },
          {
            "key": "smooth",
            "displayName": "smooth",
            "aliases": [
              "smooth"
            ],
            "values": "boolean",
            "description": "Enables smooth scrolling"
          },
          {
            "key": "animatein",
            "displayName": "animatein",
            "aliases": [
              "animatein"
            ],
            "values": "string",
            "description": "Sets specific entrance animation (see animate.css)"
          },
          {
            "key": "animateout",
            "displayName": "animateout",
            "aliases": [
              "animateout"
            ],
            "values": "string",
            "description": "Sets specific exit animation (see animate.css)"
          }
        ]
      },
      {
        "title": "Message Display Parameters",
        "slug": "message-display-parameters",
        "description": "",
        "items": [
          {
            "key": "showtime",
            "displayName": "showtime",
            "aliases": [
              "showtime"
            ],
            "values": "number",
            "description": "Auto-hides messages after specified milliseconds"
          },
          {
            "key": "delaytime",
            "displayName": "delaytime",
            "aliases": [
              "delaytime"
            ],
            "values": "number",
            "description": "Delays showing messages by specified milliseconds"
          },
          {
            "key": "trim",
            "displayName": "trim",
            "aliases": [
              "trim"
            ],
            "values": "number",
            "description": "Trims messages longer than specified characters"
          },
          {
            "key": "trimname",
            "displayName": "trimname",
            "aliases": [
              "trimname"
            ],
            "values": "number",
            "description": "Trims usernames longer than specified characters"
          },
          {
            "key": "hidenames",
            "displayName": "hidenames",
            "aliases": [
              "hidenames"
            ],
            "values": "boolean",
            "description": "Hides usernames completely"
          },
          {
            "key": "firstnamesonly",
            "displayName": "firstnamesonly or firstname or firstnames",
            "aliases": [
              "firstnamesonly",
              "firstname",
              "firstnames"
            ],
            "values": "boolean",
            "description": "Shows only first names of users"
          },
          {
            "key": "hidesource",
            "displayName": "hidesource",
            "aliases": [
              "hidesource"
            ],
            "values": "boolean",
            "description": "Hides the source platform icons (YouTube, Twitch, etc.)"
          },
          {
            "key": "noavatar",
            "displayName": "noavatar or noavatars",
            "aliases": [
              "noavatar",
              "noavatars"
            ],
            "values": "boolean",
            "description": "Hides user avatars"
          },
          {
            "key": "nobadges",
            "displayName": "nobadges or hidebadges",
            "aliases": [
              "nobadges",
              "hidebadges"
            ],
            "values": "boolean",
            "description": "Hides user badges"
          },
          {
            "key": "limitbadges",
            "displayName": "limitbadges",
            "aliases": [
              "limitbadges"
            ],
            "values": "number",
            "description": "Limits number of badges shown per message"
          },
          {
            "key": "notime",
            "displayName": "notime or notimestamp or nodate",
            "aliases": [
              "notime",
              "notimestamp",
              "nodate"
            ],
            "values": "boolean",
            "description": "Hides timestamp"
          },
          {
            "key": "24hr",
            "displayName": "24hr",
            "aliases": [
              "24hr"
            ],
            "values": "boolean",
            "description": "Displays timestamps using 24-hour format"
          },
          {
            "key": "sequence",
            "displayName": "sequence",
            "aliases": [
              "sequence"
            ],
            "values": "boolean",
            "description": "Hides name/icons if sequential messages from same user"
          },
          {
            "key": "attachmentsonly",
            "displayName": "attachmentsonly",
            "aliases": [
              "attachmentsonly"
            ],
            "values": "boolean",
            "description": "Displays only messages that include an attached image or clip"
          },
          {
            "key": "hidequestions",
            "displayName": "hidequestions",
            "aliases": [
              "hidequestions"
            ],
            "values": "boolean",
            "description": "Hides cards flagged as questions"
          },
          {
            "key": "onlyquestions",
            "displayName": "onlyquestions",
            "aliases": [
              "onlyquestions"
            ],
            "values": "boolean",
            "description": "Shows only messages that contain question metadata"
          },
          {
            "key": "hidenumbers",
            "displayName": "hidenumbers",
            "aliases": [
              "hidenumbers"
            ],
            "values": "boolean",
            "description": "Hides numerical message counters on cards"
          },
          {
            "key": "showsourcename",
            "displayName": "showsourcename",
            "aliases": [
              "showsourcename"
            ],
            "values": "boolean",
            "description": "Displays the originating platform label on each card"
          },
          {
            "key": "showviewercount",
            "displayName": "showviewercount",
            "aliases": [
              "showviewercount"
            ],
            "values": "boolean",
            "description": "Shows the current viewer count indicator"
          },
          {
            "key": "nocolon",
            "displayName": "nocolon",
            "aliases": [
              "nocolon"
            ],
            "values": "boolean",
            "description": "Removes the colon between username and message body"
          },
          {
            "key": "namefilter",
            "displayName": "namefilter",
            "aliases": [
              "namefilter"
            ],
            "values": "boolean",
            "description": "Applies filters to usernames instead of message text"
          },
          {
            "key": "stripreplyto",
            "displayName": "stripreplyto",
            "aliases": [
              "stripreplyto"
            ],
            "values": "boolean",
            "description": "Removes “replying to” prefaces from imported messages"
          },
          {
            "key": "normalize",
            "displayName": "normalize",
            "aliases": [
              "normalize"
            ],
            "values": "boolean",
            "description": "Normalizes characters (e.g., removes diacritics) for comparisons"
          }
        ]
      },
      {
        "title": "Filtering Parameters",
        "slug": "filtering-parameters",
        "description": "",
        "items": [
          {
            "key": "hidecommands",
            "displayName": "hidecommands",
            "aliases": [
              "hidecommands"
            ],
            "values": "boolean",
            "description": "Hides messages starting with \"!\""
          },
          {
            "key": "hideshortmessages",
            "displayName": "hideshortmessages",
            "aliases": [
              "hideshortmessages"
            ],
            "values": "number",
            "description": "Hides messages shorter than specified length"
          },
          {
            "key": "noemojisonly",
            "displayName": "noemojisonly",
            "aliases": [
              "noemojisonly"
            ],
            "values": "boolean",
            "description": "Filters out messages containing only emojis"
          },
          {
            "key": "stripemoji",
            "displayName": "stripemoji",
            "aliases": [
              "stripemoji"
            ],
            "values": "boolean",
            "description": "Removes all emojis from messages"
          },
          {
            "key": "striphtml",
            "displayName": "striphtml or strip",
            "aliases": [
              "striphtml",
              "strip"
            ],
            "values": "boolean",
            "description": "Removes HTML formatting from messages"
          },
          {
            "key": "striplinks",
            "displayName": "striplinks",
            "aliases": [
              "striplinks"
            ],
            "values": "boolean",
            "description": "Removes links from messages"
          },
          {
            "key": "activelinks",
            "displayName": "activelinks",
            "aliases": [
              "activelinks"
            ],
            "values": "boolean",
            "description": "Makes URLs clickable"
          },
          {
            "key": "shortlink",
            "displayName": "shortlink",
            "aliases": [
              "shortlink"
            ],
            "values": "boolean",
            "description": "Shortens displayed links"
          },
          {
            "key": "onlytwitch",
            "displayName": "onlytwitch",
            "aliases": [
              "onlytwitch"
            ],
            "values": "boolean",
            "description": "Shows only Twitch messages"
          },
          {
            "key": "hidetwitch",
            "displayName": "hidetwitch",
            "aliases": [
              "hidetwitch"
            ],
            "values": "boolean",
            "description": "Hides Twitch messages"
          },
          {
            "key": "hidefrom",
            "displayName": "hidefrom or exclude",
            "aliases": [
              "hidefrom",
              "exclude"
            ],
            "values": "comma-separated strings",
            "description": "List of usernames to hide messages from"
          },
          {
            "key": "onlyfrom",
            "displayName": "onlyfrom or fromonly",
            "aliases": [
              "onlyfrom",
              "fromonly"
            ],
            "values": "comma-separated strings",
            "description": "List of usernames to exclusively show"
          },
          {
            "key": "badkarma",
            "displayName": "badkarma",
            "aliases": [
              "badkarma"
            ],
            "values": "0.0-1.0",
            "description": "Filters messages based on sentiment score"
          },
          {
            "key": "showonlymods",
            "displayName": "showonlymods",
            "aliases": [
              "showonlymods"
            ],
            "values": "boolean",
            "description": "Shows messages from moderators only"
          },
          {
            "key": "showonlyvips",
            "displayName": "showonlyvips",
            "aliases": [
              "showonlyvips"
            ],
            "values": "boolean",
            "description": "Shows messages from VIPs only"
          },
          {
            "key": "excludefiltered",
            "displayName": "excludefiltered",
            "aliases": [
              "excludefiltered"
            ],
            "values": "boolean",
            "description": "Prevents filtered messages from being auto-featured"
          }
        ]
      },
      {
        "title": "Message Selection & Queue Parameters",
        "slug": "message-selection-queue-parameters",
        "description": "",
        "items": [
          {
            "key": "autoshow",
            "displayName": "autoshow",
            "aliases": [
              "autoshow"
            ],
            "values": "boolean",
            "description": "Automatically features new messages"
          },
          {
            "key": "autoshowtime",
            "displayName": "autoshowtime",
            "aliases": [
              "autoshowtime"
            ],
            "values": "number",
            "description": "Custom timing for auto-show feature (milliseconds)"
          },
          {
            "key": "chartime",
            "displayName": "chartime",
            "aliases": [
              "chartime"
            ],
            "values": "number",
            "description": "Time per character for auto-show duration"
          },
          {
            "key": "autoshowdonos",
            "displayName": "autoshowdonos",
            "aliases": [
              "autoshowdonos"
            ],
            "values": "boolean",
            "description": "Auto-features only donation messages"
          },
          {
            "key": "autoshowmembers",
            "displayName": "autoshowmembers",
            "aliases": [
              "autoshowmembers"
            ],
            "values": "boolean",
            "description": "Auto-features only member messages"
          },
          {
            "key": "autoshowqueued",
            "displayName": "autoshowqueued",
            "aliases": [
              "autoshowqueued"
            ],
            "values": "boolean",
            "description": "Auto-shows queued messages"
          },
          {
            "key": "autoshowcontentimages",
            "displayName": "autoshowcontentimages",
            "aliases": [
              "autoshowcontentimages"
            ],
            "values": "boolean",
            "description": "Auto-features queued messages that include image/content attachments"
          },
          {
            "key": "queueonly",
            "displayName": "queueonly",
            "aliases": [
              "queueonly"
            ],
            "values": "boolean",
            "description": "Shows only queued messages"
          },
          {
            "key": "pinnedonly",
            "displayName": "pinnedonly",
            "aliases": [
              "pinnedonly"
            ],
            "values": "boolean",
            "description": "Shows only pinned messages"
          },
          {
            "key": "viewonly",
            "displayName": "viewonly",
            "aliases": [
              "viewonly"
            ],
            "values": "boolean",
            "description": "Disables chat, pin, and feature capabilities"
          },
          {
            "key": "chatmode",
            "displayName": "chatmode",
            "aliases": [
              "chatmode"
            ],
            "values": "boolean",
            "description": "Enables chat-only mode (no pin/feature)"
          },
          {
            "key": "helpermode",
            "displayName": "helpermode",
            "aliases": [
              "helpermode"
            ],
            "values": "boolean",
            "description": "Enables view/pin/queue mode (no chat/feature)"
          },
          {
            "key": "chatonly",
            "displayName": "chatonly",
            "aliases": [
              "chatonly"
            ],
            "values": "boolean",
            "description": "Moves the chat input into the toolbar for a chat-centric layout"
          },
          {
            "key": "openchat",
            "displayName": "openchat",
            "aliases": [
              "openchat"
            ],
            "values": "boolean",
            "description": "Automatically opens the chat composer on load"
          },
          {
            "key": "showmenu",
            "displayName": "showmenu",
            "aliases": [
              "showmenu"
            ],
            "values": "boolean",
            "description": "Forces the main toolbar to remain visible"
          },
          {
            "key": "sync",
            "displayName": "sync or synced",
            "aliases": [
              "sync",
              "synced"
            ],
            "values": "boolean",
            "description": "Syncs message selection across multiple docks"
          },
          {
            "key": "autopindonations",
            "displayName": "autopindonations",
            "aliases": [
              "autopindonations"
            ],
            "values": "boolean",
            "description": "Auto-pins donation cards as they arrive"
          },
          {
            "key": "autopinquestions",
            "displayName": "autopinquestions or autopinquestion",
            "aliases": [
              "autopinquestions",
              "autopinquestion"
            ],
            "values": "boolean",
            "description": "Auto-pins cards marked as questions"
          },
          {
            "key": "autoqueuedonations",
            "displayName": "autoqueuedonations or autoqueuedonation",
            "aliases": [
              "autoqueuedonations",
              "autoqueuedonation"
            ],
            "values": "boolean",
            "description": "Auto-queues donation cards"
          },
          {
            "key": "autoqueuequestions",
            "displayName": "autoqueuequestions or autoqueuequestion",
            "aliases": [
              "autoqueuequestions",
              "autoqueuequestion"
            ],
            "values": "boolean",
            "description": "Auto-queues question cards"
          },
          {
            "key": "skipdonations",
            "displayName": "skipdonations",
            "aliases": [
              "skipdonations"
            ],
            "values": "boolean",
            "description": "Prevents donation cards from being auto-featured"
          },
          {
            "key": "selfqueue",
            "displayName": "selfqueue",
            "aliases": [
              "selfqueue"
            ],
            "values": "comma-separated strings",
            "description": "Viewer commands that add themselves to the queue (e.g., !queue)"
          },
          {
            "key": "deleteonlylast",
            "displayName": "deleteonlylast",
            "aliases": [
              "deleteonlylast"
            ],
            "values": "boolean",
            "description": "Only removes the most recent card when clearing messages"
          },
          {
            "key": "disabletimeout",
            "displayName": "disabletimeout",
            "aliases": [
              "disabletimeout"
            ],
            "values": "boolean",
            "description": "Disables the auto-timeout on featured messages"
          },
          {
            "key": "altselect",
            "displayName": "altselect",
            "aliases": [
              "altselect"
            ],
            "values": "boolean",
            "description": "Keeps the Feature button visible when menus are hidden"
          },
          {
            "key": "autoscroll",
            "displayName": "autoscroll",
            "aliases": [
              "autoscroll"
            ],
            "values": "boolean",
            "description": "Scrolls to the latest message once and leaves scrolling unlocked"
          },
          {
            "key": "buffer",
            "displayName": "buffer",
            "aliases": [
              "buffer"
            ],
            "values": "boolean",
            "description": "Enables adaptive buffering for smoother message pacing"
          },
          {
            "key": "bufferdelay",
            "displayName": "bufferdelay",
            "aliases": [
              "bufferdelay"
            ],
            "values": "number",
            "description": "Base delay (ms) used when buffering messages"
          },
          {
            "key": "buffermin",
            "displayName": "buffermin",
            "aliases": [
              "buffermin"
            ],
            "values": "number",
            "description": "Minimum delay (ms) used when buffering messages"
          },
          {
            "key": "buffermax",
            "displayName": "buffermax",
            "aliases": [
              "buffermax"
            ],
            "values": "number",
            "description": "Maximum delay (ms) used when buffering messages"
          },
          {
            "key": "random",
            "displayName": "random",
            "aliases": [
              "random"
            ],
            "values": "boolean",
            "description": "Randomizes which queued message is featured next"
          }
        ]
      },
      {
        "title": "Text-to-Speech (TTS) Parameters",
        "slug": "text-to-speech-tts-parameters",
        "description": "",
        "items": [
          {
            "key": "speech",
            "displayName": "speech or tts",
            "aliases": [
              "speech",
              "tts"
            ],
            "values": "language code",
            "description": "Enables TTS with specified language (e.g., \"en-US\")"
          },
          {
            "key": "volume",
            "displayName": "volume",
            "aliases": [
              "volume"
            ],
            "values": "0.0-1.0",
            "description": "Sets TTS volume"
          },
          {
            "key": "rate",
            "displayName": "rate",
            "aliases": [
              "rate"
            ],
            "values": "number",
            "description": "Sets TTS speaking rate"
          },
          {
            "key": "pitch",
            "displayName": "pitch",
            "aliases": [
              "pitch"
            ],
            "values": "number",
            "description": "Sets TTS pitch"
          },
          {
            "key": "voice",
            "displayName": "voice",
            "aliases": [
              "voice"
            ],
            "values": "string",
            "description": "Specifies TTS voice to use"
          },
          {
            "key": "ttscommand",
            "displayName": "ttscommand",
            "aliases": [
              "ttscommand"
            ],
            "values": "string",
            "description": "Custom command to trigger TTS (default: \"!say\")"
          },
          {
            "key": "ttscommandmembersonly",
            "displayName": "ttscommandmembersonly",
            "aliases": [
              "ttscommandmembersonly"
            ],
            "values": "boolean",
            "description": "Restricts TTS command to members only"
          },
          {
            "key": "simpletts",
            "displayName": "simpletts",
            "aliases": [
              "simpletts"
            ],
            "values": "boolean",
            "description": "Simplified TTS output without \"says\" phrases"
          },
          {
            "key": "readevents",
            "displayName": "readevents",
            "aliases": [
              "readevents"
            ],
            "values": "boolean",
            "description": "Enables TTS for stream events"
          },
          {
            "key": "readouturls",
            "displayName": "readouturls",
            "aliases": [
              "readouturls"
            ],
            "values": "boolean",
            "description": "Reads URLs instead of saying \"link\""
          }
        ]
      },
      {
        "title": "Donation & Member Parameters",
        "slug": "donation-member-parameters",
        "description": "",
        "items": [
          {
            "key": "showonlydonos",
            "displayName": "showonlydonos",
            "aliases": [
              "showonlydonos"
            ],
            "values": "boolean",
            "description": "Shows only messages with donations"
          },
          {
            "key": "showonlymembers",
            "displayName": "showonlymembers",
            "aliases": [
              "showonlymembers"
            ],
            "values": "boolean",
            "description": "Shows only messages from members"
          },
          {
            "key": "stripdonations",
            "displayName": "stripdonations",
            "aliases": [
              "stripdonations"
            ],
            "values": "boolean",
            "description": "Removes donation data from messages"
          },
          {
            "key": "nodonohighlight",
            "displayName": "nodonohighlight",
            "aliases": [
              "nodonohighlight"
            ],
            "values": "boolean",
            "description": "Disables background highlighting for donations"
          },
          {
            "key": "autoyoutubememberchat",
            "displayName": "autoyoutubememberchat",
            "aliases": [
              "autoyoutubememberchat"
            ],
            "values": "boolean",
            "description": "Auto-features YouTube member milestone chat cards"
          },
          {
            "key": "tiktokfans",
            "displayName": "tiktokfans",
            "aliases": [
              "tiktokfans"
            ],
            "values": "boolean",
            "description": "Treats TikTok fans as channel members for highlighting"
          },
          {
            "key": "t1",
            "displayName": "t1",
            "aliases": [
              "t1"
            ],
            "values": "number",
            "description": "First donation threshold amount (USD)"
          },
          {
            "key": "t1c",
            "displayName": "t1c",
            "aliases": [
              "t1c"
            ],
            "values": "hex/color",
            "description": "Color for first donation threshold messages"
          },
          {
            "key": "t2",
            "displayName": "t2",
            "aliases": [
              "t2"
            ],
            "values": "number",
            "description": "Second donation threshold amount (USD)"
          },
          {
            "key": "t2c",
            "displayName": "t2c",
            "aliases": [
              "t2c"
            ],
            "values": "hex/color",
            "description": "Color for second donation threshold messages"
          },
          {
            "key": "t3",
            "displayName": "t3",
            "aliases": [
              "t3"
            ],
            "values": "number",
            "description": "Third donation threshold amount (USD)"
          },
          {
            "key": "t3c",
            "displayName": "t3c",
            "aliases": [
              "t3c"
            ],
            "values": "hex/color",
            "description": "Color for third donation threshold messages"
          }
        ]
      },
      {
        "title": "Bot & Host Control Parameters",
        "slug": "bot-host-control-parameters",
        "description": "",
        "items": [
          {
            "key": "myname",
            "displayName": "myname or botlist or botnames",
            "aliases": [
              "myname",
              "botlist",
              "botnames"
            ],
            "values": "comma-separated strings",
            "description": "List of bot usernames to identify"
          },
          {
            "key": "hidebots",
            "displayName": "hidebots",
            "aliases": [
              "hidebots"
            ],
            "values": "boolean",
            "description": "Hides messages from identified bots"
          },
          {
            "key": "hidebotnames",
            "displayName": "hidebotnames",
            "aliases": [
              "hidebotnames"
            ],
            "values": "boolean",
            "description": "Hides names of identified bots"
          },
          {
            "key": "hidehosts",
            "displayName": "hidehosts",
            "aliases": [
              "hidehosts"
            ],
            "values": "boolean",
            "description": "Hides messages from hosts"
          },
          {
            "key": "hidehostnames",
            "displayName": "hidehostnames",
            "aliases": [
              "hidehostnames"
            ],
            "values": "boolean",
            "description": "Hides names of hosts"
          },
          {
            "key": "stripat",
            "displayName": "stripat",
            "aliases": [
              "stripat"
            ],
            "values": "boolean",
            "description": "Removes @ from the start of display names"
          },
          {
            "key": "nobeepbot",
            "displayName": "nobeepbot",
            "aliases": [
              "nobeepbot"
            ],
            "values": "boolean",
            "description": "Disables notification sound for bot messages"
          },
          {
            "key": "nobeephost",
            "displayName": "nobeephost",
            "aliases": [
              "nobeephost"
            ],
            "values": "boolean",
            "description": "Disables notification sound for host messages"
          },
          {
            "key": "nobeepevent",
            "displayName": "nobeepevent",
            "aliases": [
              "nobeepevent"
            ],
            "values": "boolean",
            "description": "Disables notification sound for events"
          },
          {
            "key": "nobeepmod",
            "displayName": "nobeepmod",
            "aliases": [
              "nobeepmod"
            ],
            "values": "boolean",
            "description": "Disables notification sound for moderator messages"
          },
          {
            "key": "showvipbadge",
            "displayName": "showvipbadge",
            "aliases": [
              "showvipbadge"
            ],
            "values": "boolean",
            "description": "Shows special badge for VIP users"
          },
          {
            "key": "autofeaturevip",
            "displayName": "autofeaturevip",
            "aliases": [
              "autofeaturevip"
            ],
            "values": "boolean",
            "description": "Auto-features messages from VIP users"
          },
          {
            "key": "autofeaturepriv",
            "displayName": "autofeaturepriv",
            "aliases": [
              "autofeaturepriv"
            ],
            "values": "boolean",
            "description": "Auto-features messages from privileged users"
          }
        ]
      },
      {
        "title": "Notification & Sound Parameters",
        "slug": "notification-sound-parameters",
        "description": "",
        "items": [
          {
            "key": "beep",
            "displayName": "beep",
            "aliases": [
              "beep"
            ],
            "values": "boolean",
            "description": "Enables sound notification for new messages"
          },
          {
            "key": "beepvolume",
            "displayName": "beepvolume",
            "aliases": [
              "beepvolume"
            ],
            "values": "0-100",
            "description": "Sets volume for notification sound (percentage)"
          },
          {
            "key": "custombeep",
            "displayName": "custombeep",
            "aliases": [
              "custombeep"
            ],
            "values": "URL",
            "description": "Custom sound file URL for notifications"
          },
          {
            "key": "overlapbeep",
            "displayName": "overlapbeep",
            "aliases": [
              "overlapbeep"
            ],
            "values": "boolean",
            "description": "Enables overlapping beep sounds for rapid messages (experimental)"
          },
          {
            "key": "beepwords",
            "displayName": "beepwords",
            "aliases": [
              "beepwords"
            ],
            "values": "boolean",
            "description": "Replaces asterisks with \"beep\" in messages"
          },
          {
            "key": "quietcommands",
            "displayName": "quietcommands",
            "aliases": [
              "quietcommands"
            ],
            "values": "boolean",
            "description": "Disables the TTS beep when command shortcuts trigger"
          }
        ]
      },
      {
        "title": "OBS Integration Parameters",
        "slug": "obs-integration-parameters",
        "description": "",
        "items": [
          {
            "key": "remote",
            "displayName": "remote",
            "aliases": [
              "remote"
            ],
            "values": "boolean/string",
            "description": "Enables OBS scene state display"
          },
          {
            "key": "cycle",
            "displayName": "cycle",
            "aliases": [
              "cycle"
            ],
            "values": "boolean",
            "description": "Allows guests to change OBS scenes with !cycle"
          },
          {
            "key": "startstop",
            "displayName": "startstop",
            "aliases": [
              "startstop"
            ],
            "values": "boolean",
            "description": "Allows privileged users to start/stop OBS"
          },
          {
            "key": "server",
            "displayName": "server",
            "aliases": [
              "server"
            ],
            "values": "URL",
            "description": "Custom WebSocket server URL"
          },
          {
            "key": "server2",
            "displayName": "server2",
            "aliases": [
              "server2"
            ],
            "values": "URL",
            "description": "Secondary WebSocket server URL"
          },
          {
            "key": "server3",
            "displayName": "server3",
            "aliases": [
              "server3"
            ],
            "values": "URL",
            "description": "Tertiary WebSocket server URL"
          },
          {
            "key": "lanonly",
            "displayName": "lanonly",
            "aliases": [
              "lanonly"
            ],
            "values": "boolean",
            "description": "Restricts P2P connections to LAN only"
          }
        ]
      },
      {
        "title": "External Automation & Integrations",
        "slug": "external-automation-integrations",
        "description": "",
        "items": [
          {
            "key": "postserver",
            "displayName": "postserver",
            "aliases": [
              "postserver"
            ],
            "values": "URL",
            "description": "Endpoint that receives featured message data via POST"
          },
          {
            "key": "putserver",
            "displayName": "putserver",
            "aliases": [
              "putserver"
            ],
            "values": "URL",
            "description": "Endpoint that receives featured message data via PUT"
          },
          {
            "key": "h2rurl",
            "displayName": "h2rurl",
            "aliases": [
              "h2rurl"
            ],
            "values": "URL",
            "description": "Base URL for H2R Graphics API posts"
          },
          {
            "key": "h2r",
            "displayName": "h2r",
            "aliases": [
              "h2r"
            ],
            "values": "string",
            "description": "Path or endpoint suffix appended to h2rurl"
          },
          {
            "key": "spxserver",
            "displayName": "spxserver",
            "aliases": [
              "spxserver"
            ],
            "values": "URL",
            "description": "Base URL for SPX-GC"
          },
          {
            "key": "spxfunction",
            "displayName": "spxfunction",
            "aliases": [
              "spxfunction"
            ],
            "values": "string",
            "description": "SPX function invoked when a message is featured"
          },
          {
            "key": "spxlayer",
            "displayName": "spxlayer",
            "aliases": [
              "spxlayer"
            ],
            "values": "string",
            "description": "SPX template/layer identifier to update"
          },
          {
            "key": "singular",
            "displayName": "singular",
            "aliases": [
              "singular"
            ],
            "values": "string",
            "description": "Singular.live data node ID for webhook updates"
          },
          {
            "key": "passtts",
            "displayName": "passtts",
            "aliases": [
              "passtts"
            ],
            "values": "boolean",
            "description": "Allows the !pass shortcut to forward TTS to remote automation"
          },
          {
            "key": "passttsmod",
            "displayName": "passttsmod",
            "aliases": [
              "passttsmod"
            ],
            "values": "boolean",
            "description": "Restricts the !pass TTS shortcut to moderators"
          },
          {
            "key": "v",
            "displayName": "v",
            "aliases": [
              "v"
            ],
            "values": "string",
            "description": "Overrides the dock version used for remote compatibility checks"
          }
        ]
      },
      {
        "title": "Export & Saving Parameters",
        "slug": "export-saving-parameters",
        "description": "",
        "items": [
          {
            "key": "save",
            "displayName": "save",
            "aliases": [
              "save"
            ],
            "values": "boolean",
            "description": "Auto-saves messages to downloads folder"
          },
          {
            "key": "savesingle",
            "displayName": "savesingle",
            "aliases": [
              "savesingle"
            ],
            "values": "boolean",
            "description": "Saves last message to a file"
          },
          {
            "key": "savefeatured",
            "displayName": "savefeatured",
            "aliases": [
              "savefeatured"
            ],
            "values": "boolean",
            "description": "Saves featured message to file"
          },
          {
            "key": "saveimg",
            "displayName": "saveimg",
            "aliases": [
              "saveimg"
            ],
            "values": "boolean",
            "description": "Includes user avatar URLs when saving"
          },
          {
            "key": "reload",
            "displayName": "reload",
            "aliases": [
              "reload"
            ],
            "values": "boolean",
            "description": "Reloads last ~50 messages on refresh"
          },
          {
            "key": "loadlast",
            "displayName": "loadlast",
            "aliases": [
              "loadlast"
            ],
            "values": "number",
            "description": "Loads specified number of messages from database"
          }
        ]
      },
      {
        "title": "Professional API Integration Parameters",
        "slug": "professional-api-integration-parameters",
        "description": "",
        "items": [
          {
            "key": "ttskey",
            "displayName": "ttskey or googlettskey",
            "aliases": [
              "ttskey",
              "googlettskey"
            ],
            "values": "string",
            "description": "Google Cloud TTS API key"
          },
          {
            "key": "elevenlabskey",
            "displayName": "elevenlabskey",
            "aliases": [
              "elevenlabskey"
            ],
            "values": "string",
            "description": "ElevenLabs TTS API key"
          },
          {
            "key": "speechifykey",
            "displayName": "speechifykey",
            "aliases": [
              "speechifykey"
            ],
            "values": "string",
            "description": "Speechify TTS API key"
          }
        ]
      },
      {
        "title": "Google Cloud TTS Parameters",
        "slug": "google-cloud-tts-parameters",
        "description": "",
        "items": [
          {
            "key": "googlerate",
            "displayName": "googlerate",
            "aliases": [
              "googlerate"
            ],
            "values": "float",
            "description": "Google TTS speaking rate"
          },
          {
            "key": "googlepitch",
            "displayName": "googlepitch",
            "aliases": [
              "googlepitch"
            ],
            "values": "float",
            "description": "Google TTS pitch adjustment"
          },
          {
            "key": "googleaudioprofile",
            "displayName": "googleaudioprofile",
            "aliases": [
              "googleaudioprofile"
            ],
            "values": "string",
            "description": "Audio profile (e.g., \"handset-class-device\")"
          },
          {
            "key": "voicegoogle",
            "displayName": "voicegoogle",
            "aliases": [
              "voicegoogle"
            ],
            "values": "string",
            "description": "Google TTS voice name (e.g., \"en-GB-Standard-A\")"
          }
        ]
      },
      {
        "title": "ElevenLabs TTS Parameters",
        "slug": "elevenlabs-tts-parameters",
        "description": "",
        "items": [
          {
            "key": "elevenlatency",
            "displayName": "elevenlatency",
            "aliases": [
              "elevenlatency"
            ],
            "values": "0-4",
            "description": "Latency optimization level"
          },
          {
            "key": "elevenstability",
            "displayName": "elevenstability",
            "aliases": [
              "elevenstability"
            ],
            "values": "0.0-1.0",
            "description": "Voice stability setting"
          },
          {
            "key": "elevensimilarity",
            "displayName": "elevensimilarity",
            "aliases": [
              "elevensimilarity"
            ],
            "values": "0.0-1.0",
            "description": "Voice similarity boost"
          },
          {
            "key": "elevenstyle",
            "displayName": "elevenstyle",
            "aliases": [
              "elevenstyle"
            ],
            "values": "0.0-1.0",
            "description": "Style intensity"
          },
          {
            "key": "elevenrate",
            "displayName": "elevenrate",
            "aliases": [
              "elevenrate"
            ],
            "values": "float",
            "description": "Speaking rate"
          },
          {
            "key": "elevenspeakerboost",
            "displayName": "elevenspeakerboost",
            "aliases": [
              "elevenspeakerboost"
            ],
            "values": "boolean",
            "description": "Enables speaker boost"
          },
          {
            "key": "voice11",
            "displayName": "voice11 or elevenlabsvoice",
            "aliases": [
              "voice11",
              "elevenlabsvoice"
            ],
            "values": "string",
            "description": "Voice ID"
          },
          {
            "key": "elevenlabsmodel",
            "displayName": "elevenlabsmodel",
            "aliases": [
              "elevenlabsmodel"
            ],
            "values": "string",
            "description": "Model selection"
          }
        ]
      },
      {
        "title": "Speechify Parameters",
        "slug": "speechify-parameters",
        "description": "",
        "items": [
          {
            "key": "speechifyspeed",
            "displayName": "speechifyspeed",
            "aliases": [
              "speechifyspeed"
            ],
            "values": "float",
            "description": "Speaking speed"
          },
          {
            "key": "speechifymodel",
            "displayName": "speechifymodel",
            "aliases": [
              "speechifymodel"
            ],
            "values": "string",
            "description": "Model selection (e.g., 'simba-english')"
          },
          {
            "key": "voicespeechify",
            "displayName": "voicespeechify",
            "aliases": [
              "voicespeechify"
            ],
            "values": "string",
            "description": "Voice selection"
          }
        ]
      },
      {
        "title": "Event Handling Parameters",
        "slug": "event-handling-parameters",
        "description": "",
        "items": [
          {
            "key": "filterevents",
            "displayName": "filterevents",
            "aliases": [
              "filterevents"
            ],
            "values": "comma-separated strings",
            "description": "List of event types to filter"
          },
          {
            "key": "trivialevents",
            "displayName": "trivialevents",
            "aliases": [
              "trivialevents"
            ],
            "values": "boolean",
            "description": "Allows background shading for minor events"
          },
          {
            "key": "showonlyevents",
            "displayName": "showonlyevents",
            "aliases": [
              "showonlyevents"
            ],
            "values": "boolean",
            "description": "Shows only stream events"
          },
          {
            "key": "hideallevents",
            "displayName": "hideallevents",
            "aliases": [
              "hideallevents"
            ],
            "values": "boolean",
            "description": "Hides all stream events"
          },
          {
            "key": "dissolve",
            "displayName": "dissolve",
            "aliases": [
              "dissolve"
            ],
            "values": "boolean",
            "description": "Stream events fade away after 3s"
          }
        ]
      },
      {
        "title": "Privacy & Security Parameters",
        "slug": "privacy-security-parameters",
        "description": "",
        "items": [
          {
            "key": "privateonly",
            "displayName": "privateonly",
            "aliases": [
              "privateonly"
            ],
            "values": "boolean",
            "description": "Shows only private messages"
          },
          {
            "key": "includeprivate",
            "displayName": "includeprivate",
            "aliases": [
              "includeprivate"
            ],
            "values": "boolean",
            "description": "Includes private messages"
          },
          {
            "key": "password",
            "displayName": "password",
            "aliases": [
              "password"
            ],
            "values": "string",
            "description": "Sets password for connection"
          },
          {
            "key": "localserver",
            "displayName": "localserver",
            "aliases": [
              "localserver"
            ],
            "values": "boolean",
            "description": "Uses local WebSocket server"
          }
        ]
      },
      {
        "title": "Debug & Development Parameters",
        "slug": "debug-development-parameters",
        "description": "",
        "items": [
          {
            "key": "debug",
            "displayName": "debug",
            "aliases": [
              "debug"
            ],
            "values": "boolean",
            "description": "Enables debug mode"
          },
          {
            "key": "notobs",
            "displayName": "notobs",
            "aliases": [
              "notobs"
            ],
            "values": "boolean",
            "description": "Disables OBS studio detection"
          },
          {
            "key": "filtertid",
            "displayName": "filtertid",
            "aliases": [
              "filtertid"
            ],
            "values": "comma-separated numbers",
            "description": "Filter by thread IDs"
          },
          {
            "key": "branded",
            "displayName": "branded",
            "aliases": [
              "branded"
            ],
            "values": "boolean",
            "description": "Shows channel icon"
          }
        ]
      }
    ]
  },
  {
    "title": "Other options for other overlays.",
    "slug": "other-options-for-other-overlays",
    "description": "WIP.",
    "sections": []
  }
]);
export const URL_PARAMETER_LOOKUP = createLookup(URL_PARAMETER_GROUPS);

export function findUrlParameter(name) {
  if (!name) {
    return null;
  }
  const key = String(name).trim().toLowerCase();
  return URL_PARAMETER_LOOKUP[key] || null;
}

export default URL_PARAMETER_GROUPS;
