(function () {
	 
	
	var isExtensionOn = true;
function toDataURL(url, callback) {
	  var xhr = new XMLHttpRequest();
	  xhr.onload = function() {
		  
		var blob = xhr.response;
    
		if (blob.size > (55 * 1024)) {
		  callback(url); // Image size is larger than 25kb.
		  return;
		}

		var reader = new FileReader();
		
		
		reader.onloadend = function() {
		  callback(reader.result);
		}
		reader.readAsDataURL(xhr.response);
	  };
	  xhr.open('GET', url);
	  xhr.responseType = 'blob';
	  xhr.send();
	}
	
	function escapeHtml(unsafe){
		try {
			if (settings.textonlymode){ // we can escape things later, as needed instead I guess.
				return unsafe;
			}
			return unsafe
				 .replace(/&/g, "&amp;")
				 .replace(/</g, "&lt;")
				 .replace(/>/g, "&gt;")
				 .replace(/"/g, "&quot;")
				 .replace(/'/g, "&#039;") || "";
		} catch(e){
			return "";
		}
	}

	function getAllContentNodes(element) { // takes an element.
		var resp = "";
		
		if (!element){return resp;}
		
		if (!element.childNodes || !element.childNodes.length){
			if (element.textContent){
				return escapeHtml(element.textContent) || "";
			} else {
				return "";
			}
		}

		function appendSpaceIfNeeded() {
			if (resp && !/\s$/.test(resp)) {
				resp += " ";
			}
		}

		function getLinkLabel(node) {
			try {
				var label = (node.textContent || "").trim();
				if (!label){
					label = node.getAttribute("aria-label") || node.getAttribute("title") || node.href || "";
				}
				return (label || "").trim();
			} catch (e) {
				return "";
			}
		}
		
		element.childNodes.forEach(node=>{
			if (node.nodeType === 3 && node.textContent !== undefined){
				var text = node.textContent || "";
				if (!text.trim()){
					appendSpaceIfNeeded();
					return;
				}
				resp += escapeHtml(text);
				return;
			}
			
			if (node.nodeType === 1){
				if (node.nodeName === "A"){
					var linkLabel = getLinkLabel(node);
					if (linkLabel){
						resp += escapeHtml(linkLabel);
					}
					return;
				}
				if (node.nodeName === "SVG" || node.nodeName === "PATH" || node.nodeName === "G"){
					return;
				}
			}
			
			if (node.childNodes && node.childNodes.length){
				resp += getAllContentNodes(node);
			} else if (node.nodeType === 1){
				if (!settings.textonlymode){
					if ((node.nodeName == "IMG") && node.src){
						node.src = node.src+"";
					}
					resp += node.outerHTML;
				}
			}
		});
		return resp;
	}
	
	function processMessage(ele){
		
		var name="";
		name = ele.querySelector('[class*="comment__author"]').innerText;
		if (name){
			name = name.replace("@","");
			name = name.trim();
			name = escapeHtml(name);
		} else {
			name = "";
		}
		
		var chatimg = '';
		
		var msg = "";
		try {
			const textContainer = ele.querySelector(".livestreamComment__text, .livestream-comment__text");
			const messageNode = textContainer ? (textContainer.querySelector("p") || textContainer) : null;
			msg = getAllContentNodes(messageNode).trim();
		} catch (e) {
			msg = "";
		}
		
		if (!msg.length){return;}
		
		try {
			chatimg = ele.querySelector("[class^='channel-thumbnail']  img[src]").src || "";
		} catch (e){}
		
		var dono = "";
		//if (ele.querySelector('.chat-history--rant-price')){
		//	dono = ele.querySelector('.chat-history--rant-price').innerText;
		//}
		
		var data = {};
		data.chatname = name;
		data.chatbadges = "";
		data.backgroundColor = "";
		data.textColor = "";
		data.chatmessage = msg;
		data.chatimg = chatimg;
		data.hasDonation = dono;
		data.membership = "";;
		data.contentimg = "";
		data.textonly = settings.textonlymode || false;
		data.type = "odysee";
		
		pushMessage(data);
	}

	function pushMessage(data){
		try{
			chrome.runtime.sendMessage(chrome.runtime.id, { "message": data }, function(e){});
		} catch(e){
		}
	}
	
	var settings = {};
	// settings.textonlymode
	// settings.captureevents
	
	
	chrome.runtime.sendMessage(chrome.runtime.id, { "getSettings": true }, function(response){  // {"state":isExtensionOn,"streamID":channel, "settings":settings}
		if (typeof chrome !== "undefined" && chrome.runtime && chrome.runtime.lastError) { return; }
		response = response || {};
		if ("settings" in response){
			settings = response.settings;
		}
	});

	chrome.runtime.onMessage.addListener(
		function (request, sender, sendResponse) {
			try{
				if ("getSource" == request){sendResponse("odysee");	return;	}
				if ("focusChat" == request){ // if (prev.querySelector('[id^="message-username-"]')){ //slateTextArea-
					document.querySelector('#create__comment').focus();
					sendResponse(true);
					return;
				}
				if (typeof request === "object"){
					if ("settings" in request){
						settings = request.settings;
						sendResponse(true);
						return;
					}
				}
			} catch(e){}
			sendResponse(false);
		}
	);

	function onElementInserted(target) {
		var onMutationsObserved = function(mutations) {
			mutations.forEach(function(mutation) {
				if (mutation.addedNodes.length) {
					for (var i = 0, len = mutation.addedNodes.length; i < len; i++) {
						try {
							if (mutation.addedNodes[i].skip){return;}
							mutation.addedNodes[i].skip = true;
							if (mutation.addedNodes[i].classList.contains("livestream__comment")){
								processMessage(mutation.addedNodes[i]);
							}
						} catch(e){}
					}
				}
			});
		};
		if (!target){return;}
		var config = { childList: true, subtree: true };
		var MutationObserver = window.MutationObserver || window.WebKitMutationObserver;
		var observer = new MutationObserver(onMutationsObserved);
		observer.observe(target, config);
	}
	
	console.log("social stream injected");

	setInterval(function(){
		if (document.querySelector('#main-content')){
			if (!document.querySelector('#main-content').marked){
				document.querySelector('#main-content').marked=true;
				onElementInserted(document.querySelector('#main-content'));
			}
		}
	},1000);

})();
