(function () {
	 
	
	var isExtensionOn = true;
function toDataURL(url, callback) {
	  var xhr = new XMLHttpRequest();
	  xhr.onload = function() {
		  
		var blob = xhr.response;
    
		if (blob.size > (55 * 1024)) {
		  callback(url); // Image size is larger than 25kb.
		  return;
		}

		var reader = new FileReader();
		
		
		reader.onloadend = function() {
		  callback(reader.result);
		}
		reader.readAsDataURL(xhr.response);
	  };
	  xhr.open('GET', url);
	  xhr.responseType = 'blob';
	  xhr.send();
	}
	
	function escapeHtml(unsafe){
		try {
			if (settings.textonlymode){ // we can escape things later, as needed instead I guess.
				return unsafe;
			}
			return unsafe
				 .replace(/&/g, "&amp;")
				 .replace(/</g, "&lt;")
				 .replace(/>/g, "&gt;")
				 .replace(/"/g, "&quot;")
				 .replace(/'/g, "&#039;") || "";
		} catch(e){
			return "";
		}
	}

	function getAllContentNodes(element) { // takes an element.
		var resp = "";
		
		if (!element){return resp;}
		
		if (!element.childNodes || !element.childNodes.length){
			if (element.textContent){
				return escapeHtml(element.textContent) || "";
			} else {
				return "";
			}
		}
		
		element.childNodes.forEach(node=>{
			if (node.childNodes.length){
				resp += getAllContentNodes(node)
			} else if ((node.nodeType === 3) && node.textContent && (node.textContent.trim().length > 0)){
				resp += escapeHtml(node.textContent);
			} else if (node.nodeType === 1){
				if (!settings.textonlymode){
					if ((node.nodeName == "IMG") && node.src){
						node.src = node.src+"";
					}
					resp += node.outerHTML;
				}
			}
		});
		return resp;
	}
	
	function processMessage(ele){
		var chatimg = "";
		var msg = "";
		var name = "";
		
		try{
			msg = ele.querySelector("converse-chat-message-body").innerText;
			if (msg){
				msg = msg.trim();
				msg = escapeHtml(msg);
			}
		} catch(e){}
		
		var prev = ele;
		while (prev.querySelectorAll(".chat-msg--followup").length==1){
			prev = prev.previousElementSibling;
		}
		
		try{
		   chatimg = prev.querySelector("converse-avatar").querySelector("image").href.baseVal;
		   if (chatimg.startsWith("data:image/svg")){
			   chatimg = ""; // I'll just use a generic avatar instead.
		   }
		} catch(e){
			// no avatar image found
		}
		
		try{
			name = prev.querySelector(".chat-msg__author").innerText;
			if (name){
				name = name.trim();
				name = escapeHtml(name);
			}
		} catch(e){}
		
		
		var data = {};
		data.chatname = name;
		data.chatbadges = "";
		data.backgroundColor = "";
		data.textColor = "";
		data.chatmessage = msg;
		data.chatimg = chatimg;
		data.hasDonation = "";
		data.membership = "";;
		data.contentimg = "";
		data.textonly = settings.textonlymode || false;
		data.type = "peertube";
		
		pushMessage(data);
	}

	function pushMessage(data){
		try{
			chrome.runtime.sendMessage(chrome.runtime.id, { "message": data }, function(){});
		} catch(e){}
	}
	
	var settings = {};
	// settings.textonlymode
	// settings.captureevents
	//var counter = 0;
	
	var counter = 3;
	chrome.runtime.sendMessage(chrome.runtime.id, { "getSettings": true }, function(response){  // {"state":isExtensionOn,"streamID":channel, "settings":settings}
		if (typeof chrome !== "undefined" && chrome.runtime && chrome.runtime.lastError) { return; }
		response = response || {};
		if ("settings" in response){
			settings = response.settings;
			if (response.state){
				if (!localStorage.getItem("access_token") && !document.querySelector(".chat-content__messages")){
					if (location.href.includes("/router/webchat/room/")){
						var conf = confirm("You might need to sign into this peer-tube site first to view chat.\n\nWould you like to try that now?");
						if (conf){
							location.href = "https://"+location.hostname+"/login";
						}
						
					}
				}
			}
			
		}
	});
	
	chrome.runtime.onMessage.addListener(
		function (request, sender, sendResponse) {
			try{
				
				if ("getSource" == request){sendResponse("peertube");	return;	}
				if ("focusChat" == request){
					document.querySelector('textarea').focus();
					sendResponse(true);
					return;
				}
				if (typeof request === "object"){
					
					if ("settings" in request){
						settings = request.settings;
						sendResponse(true);
						return;
					}
				}
			} catch(e){}
			sendResponse(false);
		}
	);

	function onElementInserted(target) {
		var onMutationsObserved = function(mutations) {
			mutations.forEach(function(mutation) {
				if (mutation.addedNodes.length) {
					for (var i = 0, len = mutation.addedNodes.length; i < len; i++) {
						try{
							if (mutation.addedNodes[i].tagName.toLowerCase() == "converse-chat-message"){
								setTimeout(function(ele){processMessage(ele);},300, mutation.addedNodes[i]);
							}
						} catch(e){}
					}
				}
			});
		};
		if (!target){return;}
		var config = { childList: true, subtree: true };
		var MutationObserver = window.MutationObserver || window.WebKitMutationObserver;
		var observer = new MutationObserver(onMutationsObserved);
		observer.observe(target, config);
	}
	console.log("social stream injected");
	
	
	var integrateInterval = setInterval(function(){
		
		if (document.querySelector(".chat-content__messages")){
			if (!document.querySelector(".chat-content__messages").marked){
				clearInterval(integrateInterval);
				document.querySelector(".chat-content__messages").marked=true;
				onElementInserted(document.querySelector(".chat-content__messages"));
			}
		}
	},1000);

})();